/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Pair;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_3532;
import org.apache.commons.lang3.mutable.MutableInt;

public class ItemHelper {
    public static void dropContents(class_1937 world, class_2338 pos, Storage<ItemVariant> inv) {
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : TransferUtil.getNonEmpty(inv)) {
                class_1799 stack = ((ItemVariant)view.getResource()).toStack((int)view.getAmount());
                class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)stack);
            }
        }
    }

    public static List<class_1799> multipliedOutput(class_1799 in, class_1799 out) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        class_1799 result = out.method_7972();
        result.method_7939(in.method_7947() * out.method_7947());
        while (result.method_7947() > result.method_7914()) {
            stacks.add(result.method_7971(result.method_7914()));
        }
        stacks.add(result);
        return stacks;
    }

    public static void addToList(class_1799 stack, List<class_1799> stacks) {
        for (class_1799 s : stacks) {
            if (!ItemHandlerHelper.canItemStacksStack((class_1799)stack, (class_1799)s)) continue;
            int transferred = Math.min(s.method_7914() - s.method_7947(), stack.method_7947());
            s.method_7933(transferred);
            stack.method_7934(transferred);
        }
        if (stack.method_7947() > 0) {
            stacks.add(stack);
        }
    }

    public static int calcRedstoneFromInventory(@Nullable Storage<ItemVariant> inv) {
        if (inv == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        int totalSlots = 0;
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : inv) {
                long slotLimit = view.getCapacity();
                if (slotLimit == 0L) continue;
                ++totalSlots;
                if (view.isResourceBlank()) continue;
                f += (float)view.getAmount() / (float)Math.min(slotLimit, (long)((ItemVariant)view.getResource()).getItem().method_7882());
                ++i;
            }
        }
        if (totalSlots == 0) {
            return 0;
        }
        return class_3532.method_15375((float)((f /= (float)totalSlots) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static List<Pair<class_1856, MutableInt>> condenseIngredients(class_2371<class_1856> recipeIngredients) {
        ArrayList<Pair<class_1856, MutableInt>> actualIngredients = new ArrayList<Pair<class_1856, MutableInt>>();
        block0: for (class_1856 igd : recipeIngredients) {
            block1: for (Pair pair : actualIngredients) {
                class_1799[] stacks2;
                class_1799[] stacks1 = ((class_1856)pair.getFirst()).method_8105();
                if (stacks1.length != (stacks2 = igd.method_8105()).length) continue;
                for (int i = 0; i <= stacks1.length; ++i) {
                    if (i == stacks1.length) {
                        ((MutableInt)pair.getSecond()).increment();
                        continue block0;
                    }
                    if (!class_1799.method_7973((class_1799)stacks1[i], (class_1799)stacks2[i])) continue block1;
                }
            }
            actualIngredients.add(Pair.of(igd, new MutableInt(1)));
        }
        return actualIngredients;
    }

    public static boolean matchIngredients(class_1856 i1, class_1856 i2) {
        class_1799[] stacks2;
        if (i1 == i2) {
            return true;
        }
        class_1799[] stacks1 = i1.method_8105();
        if (stacks1 == (stacks2 = i2.method_8105())) {
            return true;
        }
        if (stacks1.length == stacks2.length) {
            for (int i = 0; i < stacks1.length; ++i) {
                if (class_1799.method_7984((class_1799)stacks1[i], (class_1799)stacks2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean matchAllIngredients(class_2371<class_1856> ingredients) {
        if (ingredients.size() <= 1) {
            return true;
        }
        class_1856 firstIngredient = (class_1856)ingredients.get(0);
        for (int i = 1; i < ingredients.size(); ++i) {
            if (ItemHelper.matchIngredients(firstIngredient, (class_1856)ingredients.get(i))) continue;
            return false;
        }
        return true;
    }

    public static class_1799 extract(Storage<ItemVariant> inv, Predicate<class_1799> test, boolean simulate) {
        return ItemHelper.extract(inv, test, ExtractionCountMode.UPTO, (Integer)AllConfigs.SERVER.logistics.defaultExtractionLimit.get(), simulate);
    }

    public static class_1799 extract(Storage<ItemVariant> inv, Predicate<class_1799> test, int exactAmount, boolean simulate) {
        return ItemHelper.extract(inv, test, ExtractionCountMode.EXACTLY, exactAmount, simulate);
    }

    public static class_1799 extract(Storage<ItemVariant> inv, Predicate<class_1799> test, ExtractionCountMode mode, int amount, boolean simulate) {
        block28: {
            int extracted = 0;
            ItemVariant extracting = null;
            ArrayList<ItemVariant> otherTargets = null;
            if (inv.supportsExtraction()) {
                try (Transaction t = TransferUtil.getTransaction();){
                    for (StorageView view : TransferUtil.getNonEmpty(inv)) {
                        boolean sameType;
                        ItemVariant contained = (ItemVariant)view.getResource();
                        int maxStackSize = contained.getItem().method_7882();
                        int amountToExtractFromThisSlot = Math.min(ItemHelper.truncateLong(view.getAmount()), Math.min(amount - extracted, maxStackSize));
                        if (!test.test(contained.toStack(amountToExtractFromThisSlot))) continue;
                        if (extracting == null) {
                            extracting = contained;
                        }
                        if ((sameType = extracting.equals(contained)) && maxStackSize == extracted) continue;
                        if (!sameType) {
                            if (otherTargets == null) {
                                otherTargets = new ArrayList<ItemVariant>();
                            }
                            otherTargets.add(contained);
                            continue;
                        }
                        ItemVariant toExtract = extracting;
                        long actualExtracted = view.extract((Object)toExtract, (long)amountToExtractFromThisSlot, (TransactionContext)t);
                        if (actualExtracted == 0L) continue;
                        if ((extracted = (int)((long)extracted + actualExtracted)) != amount) continue;
                        if (!simulate) {
                            t.commit();
                        }
                        class_1799 class_17992 = toExtract.toStack(extracted);
                        return class_17992;
                    }
                    if (mode == ExtractionCountMode.UPTO) {
                        if (extracting != null && extracted != 0) {
                            if (!simulate) {
                                t.commit();
                            }
                            class_1799 class_17993 = extracting.toStack(extracted);
                            return class_17993;
                        }
                        break block28;
                    }
                    if (otherTargets == null) break block28;
                    t.abort();
                    try (Transaction nested = TransferUtil.getTransaction();){
                        Iterator iterator = otherTargets.iterator();
                        while (true) {
                            if (iterator.hasNext()) {
                                ItemVariant target = (ItemVariant)iterator.next();
                                class_1799 successfulExtraction = ItemHelper.extract(inv, arg_0 -> ((ItemVariant)target).matches(arg_0), mode, amount, simulate);
                                if (successfulExtraction.method_7960()) continue;
                                if (!simulate) {
                                    nested.commit();
                                }
                                class_1799 class_17994 = successfulExtraction;
                                return class_17994;
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
        }
        return class_1799.field_8037;
    }

    public static class_1799 extract(Storage<ItemVariant> inv, Predicate<class_1799> test, Function<class_1799, Integer> amountFunction, boolean simulate) {
        class_1799 extracting = class_1799.field_8037;
        int maxExtractionCount = (Integer)AllConfigs.SERVER.logistics.defaultExtractionLimit.get();
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : TransferUtil.getNonEmpty(inv)) {
                ItemVariant var = (ItemVariant)view.getResource();
                class_1799 stackInSlot = var.toStack();
                if (!test.test(stackInSlot)) continue;
                if (extracting.method_7960()) {
                    int maxExtractionCountForItem = amountFunction.apply(stackInSlot);
                    if (maxExtractionCountForItem == 0) continue;
                    maxExtractionCount = Math.min(maxExtractionCount, maxExtractionCountForItem);
                }
                Transaction nested = t.openNested();
                try {
                    long extracted = view.extract((Object)var, (long)(maxExtractionCount - extracting.method_7947()), (TransactionContext)nested);
                    class_1799 stack = var.toStack((int)extracted);
                    if (!test.test(stack) || !extracting.method_7960() && !ItemHelper.canItemStackAmountsStack(stack, extracting)) continue;
                    nested.commit();
                    if (extracting.method_7960()) {
                        extracting = stack.method_7972();
                    } else {
                        extracting.method_7933(stack.method_7947());
                    }
                    if (extracting.method_7947() < maxExtractionCount) continue;
                    break;
                }
                finally {
                    if (nested == null) continue;
                    nested.close();
                }
            }
            if (!simulate) {
                t.commit();
            }
        }
        return extracting;
    }

    public static boolean canItemStackAmountsStack(class_1799 a, class_1799 b) {
        return ItemHandlerHelper.canItemStacksStack((class_1799)a, (class_1799)b) && a.method_7947() + b.method_7947() <= a.method_7914();
    }

    public static int truncateLong(long l) {
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }

    public static enum ExtractionCountMode {
        EXACTLY,
        UPTO;

    }
}

